TRANSACTION=${1:-1}
QUANTITY=${2:-1}
SESSION_ID=${3:-1}
PRODUCT_ID=${4:-1}
LOYALTY_CODE=${5:-value-returned-for-code}
EVENT_ID=${6:-$(uuidgen)}
TOKEN={TOKEN}
BODY=`cat <<EOM
{
    "sessionId": "$SESSION_ID",
    "transactionId": $TRANSACTION,
    "status": "completed",
    "products": [{
        "RIN": "$PRODUCT_ID",
        "quantity": $QUANTITY
    }],
    "events": [
        {
            "eventId": "$EVENT_ID",
            "metadata": {"loyaltyCode": "$LOYALTY_CODE"}
        }
    ]
}
EOM
`
curl \
    -X POST \
    -H 'Content-Type: application/json' \
    -H 'X-AIFI-LocationId: 1' \
    -H "Authorization: Bearer $TOKEN" \
    -H 'X-AIFI-Store: {STORE_NAME}' \
    -d "$BODY" \
    https://{API_URL}/api/aifi/checkouts
